package parser;

/**
 * Grammar non-terminal -- E ::= S E1
 */
public class E {
    /**
     * S object.
     */
    private S _s;

    /**
     * E1 object.
     */
    private E1 _e1;

    /**
     * Constructor for the E grammar non-terminal.
     *
     * @param s  S object
     * @param e1 E1 object
     */
    public E(S s, E1 e1) {
        _s = s;
        _e1 = e1;
    }

    /**
     * Return a string representation.
     *
     * @return string representation
     */
    public String toString() {
        return _s.toString() + _e1.toString();
    }
}

